function [startpoint, endpoint]=detecionEOG_HOS_new(input, Fs,thr1,thr2)


[b, a] = butter(4, 40/(Fs/2), 'low');  
input_filtered = filter(b, a, input);  

%HOC
MM=0.5*Fs;
Czzz = HOS_will(input_filtered,MM);
% figure
% plot(Czzz);
thre0=median(abs(Czzz))*sqrt(2*log(length(Czzz)))/0.6745;   

Czzz(Czzz<thre0)=0;
[pks_eeg,locs_eeg]=findpeaks(Czzz);
if isempty(locs_eeg)==1
    startpoint=[];
    endpoint=[];
else

    max_distance = 120;
    min_distance=20;
    segments = [];
    start_idx = 1;
    for i = 2:length(locs_eeg)
        if locs_eeg(i) - locs_eeg(i-1) >max_distance%||locs_eeg(i) - locs_eeg(i-1)<min_distance
            segments = [segments; locs_eeg(start_idx), locs_eeg(i-1)];
            start_idx = i;
        end
    end
    
    segments = [segments; locs_eeg(start_idx), locs_eeg(end)];
    startpoint=segments(:,1);
    endpoint=segments(:,2);
    
    %%%%%%%Further adjustment%%%%%
    for num_EOG=1:length(startpoint)
        startpoint0=startpoint(num_EOG);
        endpoint0=endpoint(num_EOG);

        input_denoised_wav=input_filtered;
        [EOG_peak, EOG_peak_location]=max(input_denoised_wav(startpoint0:endpoint0));  %EOG_peak
        EOG_peak_location=EOG_peak_location+startpoint0;


        if (startpoint0+floor((EOG_peak_location-startpoint0)/2))>0&&(startpoint0+floor((EOG_peak_location-startpoint0)/2))<600

            while input_denoised_wav(startpoint0+floor((EOG_peak_location-startpoint0)/2))<thr1*EOG_peak
                if EOG_peak<50
                    break;
                end
                startpoint0=startpoint0+1;
            end
            
            while input_denoised_wav(startpoint0+floor((EOG_peak_location-startpoint0)/2))>(thr1+0.1)*EOG_peak
                if EOG_peak<50
                    break;
                end
                startpoint0=startpoint0-1;
                if startpoint0+floor((EOG_peak_location-startpoint0)/2)<1
                    startpoint0=1;
                    break;
                end
            end
        end
        
        if (EOG_peak_location+floor((endpoint0-EOG_peak_location)/2))>0&&(EOG_peak_location+floor((endpoint0-EOG_peak_location)/2))<600
            
            while input_denoised_wav(EOG_peak_location+floor((endpoint0-EOG_peak_location)/2))<thr2*EOG_peak
                if EOG_peak<50
                    break;
                end
                endpoint0=endpoint0-1;
            end
            
            while input_denoised_wav(EOG_peak_location+floor((endpoint0-EOG_peak_location)/2))>(thr2+0.1)*EOG_peak
                if EOG_peak<50
                    break;
                end
                endpoint0=endpoint0+1;
                if EOG_peak_location+floor((endpoint0-EOG_peak_location)/2)>600
                    endpoint0=600;
                    break;
                end
            end
        end
        if startpoint0<1
            startpoint0=1;
        end
        if endpoint0>600
            endpoint0=600;
        end
        startpoint(num_EOG)=startpoint0;
        endpoint(num_EOG)=endpoint0;
        
    end
end
end
